<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Store extends Model 
{

    protected $table = 'stores';
    public $timestamps = true;
    protected $fillable = array('category_id', 'phone', 'name', 'proposed', 'is_active');

    public function addresses()
    {
        return $this->hasMany('App\Models\StoreAddresse');
    }

    public function serviceProviderReviews()
    {
        return $this->morphMany('App\Models\Review');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

}